<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ShippingCity extends Eloquent {

	protected $table = 'shipping_city';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('city_id');

	public function city()
	{
		return $this->belongsTo('City', 'city');
	}

}