<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateKnowledgeTable extends Migration {

	public function up()
	{
		Schema::create('knowledge', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('unit_id')->unsigned()->index();
			$table->string('type');
			$table->string('subject');
			$table->string('romaji');
			$table->string('kanji')->nullable();
			$table->string('vietnamese')->nullable();
			$table->string('audio')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('knowledge');
	}
}