<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Events extends Eloquent {

	protected $table = 'events';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('profile_id', 'type_id', 'location_id', 'code', 'name');

	public function location()
	{
		return $this->hasOne('Location');
	}

	public function type()
	{
		return $this->hasOne('EventType');
	}

	public function protocol()
	{
		return $this->belongsTo('\Protocol')->withPivot('protocol_events');
	}

	public function owner()
	{
		return $this->belongsTo('Profile');
	}

	public function groups()
	{
		return $this->hasMany('Groups');
	}

}