<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class AttendeeGroup extends Model 
{

    protected $table = 'attendee_groups';
    public $timestamps = true;
    protected $fillable = array('attendee_uuid', 'group_uuid');

    public function attendee()
    {
        return $this->belongsTo('Attendee', 'attendee_uuid', 'uuid');
    }

    public function group()
    {
        return $this->belongsTo('Groups', 'group_uuid', 'uuid');
    }

}