<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class EventInvitation extends Model 
{

    protected $table = 'event_invitations';
    public $timestamps = true;
    protected $fillable = array('uuid', 'profile_type_id', 'event_uuid', 'attendee_uuid', 'status', 'phone_number', 'email', 'first_name', 'last_name', 'method', 'sent_at', 'data');

    public function event()
    {
        return $this->belongsTo('\Events', 'event_uuid', 'uuid');
    }

    public function attendee()
    {
        return $this->hasOne('Attendee', 'attendee_uuid', 'uuid');
    }

}