<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStatesTable extends Migration {

	public function up()
	{
		Schema::create('states', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('country_id')->unsigned()->nullable();
			$table->string('name');
			$table->string('code')->nullable();
			$table->text('featured_image')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('states');
	}
}