<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->uuid('uuid')->primary()->index();
			$table->uuid('uuid_student');
			$table->uuid('uuid_tutor');
			$table->string('product', 255);
			$table->decimal('amount', 8,2);
			$table->string('currency', 10);
			$table->integer('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}