<?php

namespace App\Models\CaseSetting;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CaseSetting extends Eloquent {

	protected $table = 'case_settings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('case_status_id', 'adjournment_status_id', 'case_end_reason_id');

	public function caseStatus()
	{
		return $this->hasMany('CaseStatuse');
	}

	public function adjournmentStatus()
	{
		return $this->hasMany('AdjournmentStatuse');
	}

	public function caseEndResason()
	{
		return $this->hasMany('CaseEndReason');
	}

}