<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function subscription()
    {
        return $this->hasManyThrough('Specialization', 'SpecializationUser', 'specialization_id');
    }

    public function locations()
    {
        return $this->hasMany('Location');
    }

    public function credits()
    {
        return $this->hasMany('Credit');
    }

    public function doctorAppointment()
    {
        return $this->hasMany('Appointment', 'doctor_id', 'id');
    }

    public function patientAppointment()
    {
        return $this->hasMany('Appointment', 'patient_id', 'id');
    }

    public function doctorRecommendation()
    {
        return $this->hasMany('Recommendation', 'doctor_id', 'id');
    }

    public function patientRecommendation()
    {
        return $this->hasMany('Recommendation', 'patient_id', 'id');
    }

    public function nutritionLists()
    {
        return $this->hasMany('NutritionList', 'doctor_id', 'id');
    }

    public function doctorFoodPlan()
    {
        return $this->hasMany('FoodPlan', 'doctor_id', 'id');
    }

    public function patientFoodPlan()
    {
        return $this->hasMany('FoodPlan', 'patient_id', 'id');
    }

    public function foodSumissions()
    {
        return $this->hasMany('FoodSubmission');
    }

    public function sender()
    {
        return $this->hasMany('Message', '"sender_id"', '"id"');
    }

    public function receiver()
    {
        return $this->hasMany('Message', '"receiver_id"', '"id"');
    }

}