<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReportingTable extends Migration {

	public function up()
	{
		Schema::create('reporting', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->date('day');
			$table->time('start_time')->nullable();
			$table->time('stop_time')->nullable();
			$table->time('duration')->nullable();
			$table->text('note')->nullable();
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('client_id')->unsigned()->nullable();
			$table->integer('projet_id')->unsigned()->nullable();
			$table->string('metier', 255)->nullable();
			$table->integer('tache_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('reporting');
	}
}