<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressTable extends Migration {

	public function up()
	{
		Schema::create('address', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('label', 255);
			$table->string('address', 255);
			$table->string('adress_suite', 255)->nullable();
			$table->string('zip_code', 10)->nullable();
			$table->string('city', 255)->nullable();
			$table->string('country', 255)->nullable();
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('client_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('address');
	}
}