<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccountsTable extends Migration {

	public function up()
	{
		Schema::create('accounts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('platform_id')->unsigned();
			$table->string('name', 255);
			$table->string('bin_code', 255);
			$table->tinyInteger('gender');
			$table->integer('area_id')->unsigned();
			$table->integer('age');
			$table->text('messages');
			$table->text('wish');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('accounts');
	}
}