<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('contacts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->string('name', 200);
			$table->string('email', 200);
			$table->smallInteger('type');
			$table->text('subject');
			$table->longText('body');
			$table->tinyInteger('active');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contacts');
	}
}