<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorChambersTable extends Migration {

	public function up()
	{
		Schema::create('doctor_chambers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('doctor_id')->unsigned();
			$table->integer('chamber_id')->unsigned();
			$table->string('chamber_phone_number', 16);
			$table->text('visiting_time');
			$table->integer('created_by');
			$table->integer('updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('doctor_chambers');
	}
}