<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->integer('id', true)->primary();
			$table->string('uuid')->index();
			$table->string('email', 100)->unique();
			$table->string('password', 255)->nullable()->default('NULL');
			$table->text('access_token')->nullable();
			$table->tinyInteger('verified')->default('0');
			$table->tinyInteger('guest')->default('0');
			$table->timestamp('creation_time');
			$table->timestamp('activation_time');
			$table->timestamp('last_access');
			$table->tinyInteger('deleted')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}