<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerDataTable extends Migration {

	public function up()
	{
		Schema::create('customer_data', function(Blueprint $table) {
			$table->integer('id', true)->primary();
			$table->bigInteger('customer_data_has_marchant_id')->unsigned()->nullable();
			$table->integer('customer_data_type_id')->unsigned();
			$table->string('name', 255)->nullable()->default('NULL');
			$table->string('surname', 255)->nullable()->default('NULL');
			$table->string('country_code', 3)->nullable()->default('NULL');
			$table->string('address_1', 255)->nullable()->default('NULL');
			$table->string('address_2', 255)->nullable()->default('NULL');
			$table->string('city', 255)->nullable()->default('NULL');
			$table->string('district', 255)->nullable()->default('NULL');
			$table->string('postal_code', 255)->nullable()->default('NULL');
			$table->string('phone', 255)->nullable();
			$table->longText('extra_fields')->nullable();
			$table->tinyInteger('default_address')->default('0');
			$table->timestamp('creation_time');
			$table->tinyInteger('deleted')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('customer_data');
	}
}