<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('client_id')->unsigned();
			$table->integer('order_no');
			$table->integer('provider_id')->unsigned();
			$table->string('segl_no', 100)->nullable();
			$table->string('tax_no', 100)->nullable();
			$table->date('created_date')->nullable();
			$table->string('profit_rate', 10)->nullable();
			$table->integer('maximum_repayment_period');
			$table->integer('minimum_repayment_period');
			$table->string('maximum_purchase_amount', 10)->nullable();
			$table->string('minimum_purchase_amount', 10)->nullable();
			$table->integer('repeat_product_period')->nullable();
			$table->integer('status');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}