<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderLocationsTable extends Migration {

	public function up()
	{
		Schema::create('order_locations', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('order_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->integer('district_id')->unsigned();
			$table->string('email');
			$table->string('name');
			$table->string('address');
			$table->string('neighbourhood');
			$table->string('building_number');
			$table->string('zip_code');
			$table->string('phone_number');
			$table->string('longitude');
			$table->string('latitude');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('order_locations');
	}
}