<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessagesTable extends Migration {

	public function up()
	{
		Schema::create('messages', function(Blueprint $table) {
			$table->increments('id');
			$table->string('message_body', 254);
			$table->integer('creator_id')->unsigned();
			$table->date('created_date');
			$table->integer('parent_message_id')->unsigned();
			$table->date('expiry_date');
			$table->tinyInteger('is_remember');
			$table->date('next_remind_date');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('messages');
	}
}