<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Partenaire extends Model 
{

    protected $table = 'partenaires';
    public $timestamps = true;
    protected $fillable = array('denomination', 'adresse', 'complement_adresse', 'code_postal', 'ville', 'telephone_fixe', 'telephone_portable', 'email', 'site_internet', 'prenom_contact', 'nom_contact', 'fonction_contact', 'forme_juridique', 'capital', 'siret', 'siren', 'rcs', 'naf_ape', 'infos');

    public function missions()
    {
        return $this->hasMany('App\Mission');
    }

    public function projets()
    {
        return $this->belongsToMany('App\Projet');
    }

    public function candidatures()
    {
        return $this->belongsToMany('App\Candidature');
    }

}