<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCandidaturesTable extends Migration {

	public function up()
	{
		Schema::create('candidatures', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('lieu', 255);
			$table->smallInteger('distance');
			$table->date('date_publication');
			$table->date('date_reponse');
			$table->string('denomination', 255);
			$table->string('prenom_contact', 255);
			$table->string('nom_contact', 255);
			$table->string('telephone_contact', 10);
			$table->string('email_contact', 255);
			$table->mediumInteger('montant_travaux');
			$table->smallInteger('surface')->unsigned();
			$table->smallInteger('prix_surface')->unsigned();
			$table->text('infos');
			$table->text('competences_attendues');
			$table->tinyInteger('reponse')->unsigned();
			$table->boolean('is_offre');
			$table->boolean('is_methodo');
			$table->boolean('is_retenu');
			$table->boolean('is_seconde_phase');
			$table->integer('client_id')->unsigned();
			$table->integer('collaborateur_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('candidatures');
	}
}