<?php

namespace App;

class Phase extends Eloquent {

	protected $table = 'phases';
	public $timestamps = true;
	protected $fillable = array('date_prevue', 'is_terminee', 'is_option', 'is_avenant', 'infos');

	public function type_phase()
	{
		return $this->belongsTo('App\TypePhase');
	}

	public function projet()
	{
		return $this->belongsTo('App\Projet');
	}

	public function missions()
	{
		return $this->hasMany('App\Mission');
	}

	public function evenements()
	{
		return $this->hasMany('App\Evenement');
	}

	public function factures()
	{
		return $this->hasMany('App\Facture');
	}

	public function taches()
	{
		return $this->hasMany('App\Tache');
	}

}