<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('denomination', 'adresse', 'complement_adresse', 'code_postal', 'ville', 'telephone_fixe', 'telephone_portable', 'email', 'site_internet', 'prenom_contact', 'nom_contact', 'fonction_contact', 'forme_juridique', 'capital', 'siret', 'siren', 'rcs', 'naf_ape', 'infos');

    public function projets()
    {
        return $this->hasMany('App\Projet');
    }

    public function type_client()
    {
        return $this->belongsTo('App\TypeClient');
    }

    public function evenement_prospections()
    {
        return $this->hasMany('App\EvenementProspection');
    }

    public function candidatures()
    {
        return $this->hasMany('App\Candidature');
    }

}