<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateToursTable extends Migration {

	public function up()
	{
		Schema::create('tours', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 128);
			$table->integer('author_id')->unsigned();
			$table->text('short_description')->nullable();
			$table->text('description')->nullable();
			$table->integer('thumbnail_id')->unsigned()->nullable();
			$table->decimal('timerange_hours')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tours');
	}
}