<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChMessagesTable extends Migration {

	public function up()
	{
		Schema::create('ch_messages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->boolean('is_forwarded')->nullable()->index();
			$table->integer('ch_room_id')->unsigned()->index();
			$table->integer('created_by')->unsigned()->index();
			$table->string('body', 5000)->nullable();
			$table->boolean('seen')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('ch_messages');
	}
}