<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccountsTable extends Migration {

	public function up()
	{
		Schema::create('accounts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('company_id')->unsigned();
			$table->string('name', 128);
			$table->integer('number');
			$table->string('currency_code', 100);
			$table->double('opening_balance', 15,4);
			$table->string('bank_name');
			$table->string('bank_phone');
			$table->string('bank_address');
			$table->boolean('enabled');
		});
	}

	public function down()
	{
		Schema::drop('accounts');
	}
}