<?php

namespace App\Models;

class Ov extends Eloquent {

	protected $table = 'ov';
	public $timestamps = true;
	protected $fillable = array('ovVersion', 'ovMacAddress', 'uploadTime', 'ovId', 'ovmId', 'ovmVersion', 'subscriptionId', 'networkPollTime', 'ovIpAddress', 'ovManagedVMs', 'ovPlatform', 'ovManagedHypervisors');
	protected $hidden = array('timestamps');

	public function masters()
	{
		return $this->hasMany('App\Models\MasterEquipment', 'id_ov_foreign_key');
	}

	public function licenses()
	{
		return $this->hasMany('App\Models\OvLicense', 'id_ov_foreign_key');
	}

	public function wireless()
	{
		return $this->hasMany('App\Models\WirelessEquipment', 'id_ov_foreign_key');
	}

}