<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCallTicketsTable extends Migration {

	public function up()
	{
		Schema::create('call_tickets', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('ticket_number', 50)->unique();
			$table->bigInteger('call_id')->unsigned();
			$table->bigInteger('call_invitation_id')->unsigned();
			$table->bigInteger('call_ticket_transaction_id')->unsigned()->nullable();
			$table->bigInteger('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('call_tickets');
	}
}