<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLiveInteractionsTable extends Migration {

	public function up()
	{
		Schema::create('live_interactions', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->enum('type', array('heart'));
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('live_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('live_interactions');
	}
}