<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLiveTicketsTable extends Migration {

	public function up()
	{
		Schema::create('live_tickets', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('number', 20)->unique();
			$table->boolean('is_disabled')->default(0);
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('live_id')->unsigned();
			$table->bigInteger('live_invitation_id')->unsigned();
			$table->bigInteger('live_ticket_transaction_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('live_tickets');
	}
}