<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('locale_id')->references('id')->on('locales')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_push_notifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_informations', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_informations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_blacklists', function(Blueprint $table) {
			$table->foreign('blacklist_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_blacklists', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_follows', function(Blueprint $table) {
			$table->foreign('user_follow_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_follows', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_certifications', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_certifications', function(Blueprint $table) {
			$table->foreign('user_certification_request_id')->references('id')->on('user_certification_requests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_certification_requests', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_certification_requests', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('admin_certification_history', function(Blueprint $table) {
			$table->foreign('user_certification_id')->references('id')->on('user_certifications')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('admin_certification_history', function(Blueprint $table) {
			$table->foreign('user_certification_request_id')->references('id')->on('user_certification_requests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('admin_certification_history', function(Blueprint $table) {
			$table->foreign('admin_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('model_has_permissions', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('model_has_roles', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_favorites', function(Blueprint $table) {
			$table->foreign('user_profil_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_favorites', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('post_videos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_favorites', function(Blueprint $table) {
			$table->foreign('live_id')->references('id')->on('lives')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_favorites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_threads', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('admin_reports', function(Blueprint $table) {
			$table->foreign('user_message_id')->references('id')->on('user_threads')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('admin_reports', function(Blueprint $table) {
			$table->foreign('user_review_id')->references('id')->on('user_reviews')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('admin_reports', function(Blueprint $table) {
			$table->foreign('user_profil_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('admin_reports', function(Blueprint $table) {
			$table->foreign('post_comment_id')->references('id')->on('post_comments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('admin_reports', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('post_videos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('admin_reports', function(Blueprint $table) {
			$table->foreign('live_id')->references('id')->on('lives')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('admin_reports', function(Blueprint $table) {
			$table->foreign('call_id')->references('id')->on('calls')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('admin_reports', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_comments', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('post_comments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_photos', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_videos', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_likes', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('post_likes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_likes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_reviews', function(Blueprint $table) {
			$table->foreign('user_profil_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_reviews', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_notifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_follow_requests', function(Blueprint $table) {
			$table->foreign('user_follow_id')->references('id')->on('user_follows')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_follow_requests', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_thread_messages', function(Blueprint $table) {
			$table->foreign('user_recipient_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_thread_messages', function(Blueprint $table) {
			$table->foreign('user_sender_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_locations', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_identify_users', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_identify_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_tags', function(Blueprint $table) {
			$table->foreign('locale_id')->references('id')->on('locales')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_tags', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lives', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('live_tags', function(Blueprint $table) {
			$table->foreign('locale_id')->references('id')->on('locales')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('live_tags', function(Blueprint $table) {
			$table->foreign('live_id')->references('id')->on('lives')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('call_auction_participants', function(Blueprint $table) {
			$table->foreign('call_id')->references('id')->on('lives')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('call_auction_participants', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('live_co_hosts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('live_co_hosts', function(Blueprint $table) {
			$table->foreign('live_id')->references('id')->on('lives')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('live_participants', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('live_participants', function(Blueprint $table) {
			$table->foreign('live_id')->references('id')->on('lives')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('live_participants', function(Blueprint $table) {
			$table->foreign('live_invitation_id')->references('id')->on('live_invitations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('live_invitations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('live_invitations', function(Blueprint $table) {
			$table->foreign('live_id')->references('id')->on('lives')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('live_tickets', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('live_tickets', function(Blueprint $table) {
			$table->foreign('live_id')->references('id')->on('lives')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('live_tickets', function(Blueprint $table) {
			$table->foreign('live_invitation_id')->references('id')->on('live_invitations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('live_tickets', function(Blueprint $table) {
			$table->foreign('live_ticket_transaction_id')->references('id')->on('live_ticket_transactions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_calendars', function(Blueprint $table) {
			$table->foreign('live_id')->references('id')->on('lives')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_calendars', function(Blueprint $table) {
			$table->foreign('call_id')->references('id')->on('calls')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_calendars', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('live_ticket_transactions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('live_ticket_transactions', function(Blueprint $table) {
			$table->foreign('live_id')->references('id')->on('lives')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('live_interactions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('live_interactions', function(Blueprint $table) {
			$table->foreign('live_id')->references('id')->on('lives')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('live_gifts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('live_gifts', function(Blueprint $table) {
			$table->foreign('live_id')->references('id')->on('lives')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('calls', function(Blueprint $table) {
			$table->foreign('auction_last_bidder_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('calls', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('call_auction_registers', function(Blueprint $table) {
			$table->foreign('call_id')->references('id')->on('calls')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('call_auction_registers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('call_invitations', function(Blueprint $table) {
			$table->foreign('call_id')->references('id')->on('calls')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('call_invitations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('call_ticket_transaction', function(Blueprint $table) {
			$table->foreign('call_id')->references('id')->on('calls')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('call_ticket_transaction', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('call_tickets', function(Blueprint $table) {
			$table->foreign('call_id')->references('id')->on('calls')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('call_tickets', function(Blueprint $table) {
			$table->foreign('call_invitation_id')->references('id')->on('call_invitations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('call_tickets', function(Blueprint $table) {
			$table->foreign('call_ticket_transaction_id')->references('id')->on('call_ticket_transaction')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('call_tickets', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('call_participants', function(Blueprint $table) {
			$table->foreign('call_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('call_participants', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('call_tags', function(Blueprint $table) {
			$table->foreign('locale_id')->references('id')->on('locales')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('call_tags', function(Blueprint $table) {
			$table->foreign('call_id')->references('id')->on('calls')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_certified_user_calendars', function(Blueprint $table) {
			$table->foreign('live_id')->references('id')->on('lives')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_certified_user_calendars', function(Blueprint $table) {
			$table->foreign('call_id')->references('id')->on('calls')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_certified_user_calendars', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_center_of_interests', function(Blueprint $table) {
			$table->foreign('center_of_interest_id')->references('id')->on('center_of_interests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_center_of_interests', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_center_of_interests', function(Blueprint $table) {
			$table->foreign('center_of_interest_id')->references('id')->on('center_of_interests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('post_center_of_interests', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('live_center_of_interests', function(Blueprint $table) {
			$table->foreign('center_of_interest_id')->references('id')->on('center_of_interests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('live_center_of_interests', function(Blueprint $table) {
			$table->foreign('live_id')->references('id')->on('lives')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('call_center_of_interests', function(Blueprint $table) {
			$table->foreign('center_of_interest_id')->references('id')->on('center_of_interests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('call_center_of_interests', function(Blueprint $table) {
			$table->foreign('call_id')->references('id')->on('lives')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_locale_id_foreign');
		});
		Schema::table('user_push_notifications', function(Blueprint $table) {
			$table->dropForeign('user_push_notifications_user_id_foreign');
		});
		Schema::table('user_informations', function(Blueprint $table) {
			$table->dropForeign('user_informations_category_id_foreign');
		});
		Schema::table('user_informations', function(Blueprint $table) {
			$table->dropForeign('user_informations_user_id_foreign');
		});
		Schema::table('user_blacklists', function(Blueprint $table) {
			$table->dropForeign('user_blacklists_blacklist_user_id_foreign');
		});
		Schema::table('user_blacklists', function(Blueprint $table) {
			$table->dropForeign('user_blacklists_user_id_foreign');
		});
		Schema::table('user_follows', function(Blueprint $table) {
			$table->dropForeign('user_follows_user_follow_id_foreign');
		});
		Schema::table('user_follows', function(Blueprint $table) {
			$table->dropForeign('user_follows_user_id_foreign');
		});
		Schema::table('user_certifications', function(Blueprint $table) {
			$table->dropForeign('user_certifications_category_id_foreign');
		});
		Schema::table('user_certifications', function(Blueprint $table) {
			$table->dropForeign('user_certifications_user_certification_request_id_foreign');
		});
		Schema::table('user_certification_requests', function(Blueprint $table) {
			$table->dropForeign('user_certification_requests_category_id_foreign');
		});
		Schema::table('user_certification_requests', function(Blueprint $table) {
			$table->dropForeign('user_certification_requests_user_id_foreign');
		});
		Schema::table('admin_certification_history', function(Blueprint $table) {
			$table->dropForeign('admin_certification_history_user_certification_id_foreign');
		});
		Schema::table('admin_certification_history', function(Blueprint $table) {
			$table->dropForeign('admin_certification_history_user_certification_request_id_foreign');
		});
		Schema::table('admin_certification_history', function(Blueprint $table) {
			$table->dropForeign('admin_certification_history_admin_id_foreign');
		});
		Schema::table('model_has_permissions', function(Blueprint $table) {
			$table->dropForeign('model_has_permissions_permission_id_foreign');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->dropForeign('role_has_permissions_permission_id_foreign');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->dropForeign('role_has_permissions_role_id_foreign');
		});
		Schema::table('model_has_roles', function(Blueprint $table) {
			$table->dropForeign('model_has_roles_role_id_foreign');
		});
		Schema::table('user_favorites', function(Blueprint $table) {
			$table->dropForeign('user_favorites_user_profil_id_foreign');
		});
		Schema::table('user_favorites', function(Blueprint $table) {
			$table->dropForeign('user_favorites_post_id_foreign');
		});
		Schema::table('user_favorites', function(Blueprint $table) {
			$table->dropForeign('user_favorites_live_id_foreign');
		});
		Schema::table('user_favorites', function(Blueprint $table) {
			$table->dropForeign('user_favorites_user_id_foreign');
		});
		Schema::table('user_threads', function(Blueprint $table) {
			$table->dropForeign('user_threads_user_id_foreign');
		});
		Schema::table('admin_reports', function(Blueprint $table) {
			$table->dropForeign('admin_reports_user_message_id_foreign');
		});
		Schema::table('admin_reports', function(Blueprint $table) {
			$table->dropForeign('admin_reports_user_review_id_foreign');
		});
		Schema::table('admin_reports', function(Blueprint $table) {
			$table->dropForeign('admin_reports_user_profil_id_foreign');
		});
		Schema::table('admin_reports', function(Blueprint $table) {
			$table->dropForeign('admin_reports_post_comment_id_foreign');
		});
		Schema::table('admin_reports', function(Blueprint $table) {
			$table->dropForeign('admin_reports_post_id_foreign');
		});
		Schema::table('admin_reports', function(Blueprint $table) {
			$table->dropForeign('admin_reports_live_id_foreign');
		});
		Schema::table('admin_reports', function(Blueprint $table) {
			$table->dropForeign('admin_reports_call_id_foreign');
		});
		Schema::table('admin_reports', function(Blueprint $table) {
			$table->dropForeign('admin_reports_user_id_foreign');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_user_id_foreign');
		});
		Schema::table('post_comments', function(Blueprint $table) {
			$table->dropForeign('post_comments_post_id_foreign');
		});
		Schema::table('post_comments', function(Blueprint $table) {
			$table->dropForeign('post_comments_user_id_foreign');
		});
		Schema::table('post_photos', function(Blueprint $table) {
			$table->dropForeign('post_photos_post_id_foreign');
		});
		Schema::table('post_videos', function(Blueprint $table) {
			$table->dropForeign('post_videos_post_id_foreign');
		});
		Schema::table('post_likes', function(Blueprint $table) {
			$table->dropForeign('post_likes_post_id_foreign');
		});
		Schema::table('post_likes', function(Blueprint $table) {
			$table->dropForeign('post_likes_user_id_foreign');
		});
		Schema::table('user_reviews', function(Blueprint $table) {
			$table->dropForeign('user_reviews_user_profil_id_foreign');
		});
		Schema::table('user_reviews', function(Blueprint $table) {
			$table->dropForeign('user_reviews_user_id_foreign');
		});
		Schema::table('user_notifications', function(Blueprint $table) {
			$table->dropForeign('user_notifications_user_id_foreign');
		});
		Schema::table('user_follow_requests', function(Blueprint $table) {
			$table->dropForeign('user_follow_requests_user_follow_id_foreign');
		});
		Schema::table('user_follow_requests', function(Blueprint $table) {
			$table->dropForeign('user_follow_requests_user_id_foreign');
		});
		Schema::table('user_thread_messages', function(Blueprint $table) {
			$table->dropForeign('user_thread_messages_user_recipient_id_foreign');
		});
		Schema::table('user_thread_messages', function(Blueprint $table) {
			$table->dropForeign('user_thread_messages_user_sender_id_foreign');
		});
		Schema::table('post_locations', function(Blueprint $table) {
			$table->dropForeign('post_locations_post_id_foreign');
		});
		Schema::table('post_identify_users', function(Blueprint $table) {
			$table->dropForeign('post_identify_users_post_id_foreign');
		});
		Schema::table('post_identify_users', function(Blueprint $table) {
			$table->dropForeign('post_identify_users_user_id_foreign');
		});
		Schema::table('post_tags', function(Blueprint $table) {
			$table->dropForeign('post_tags_locale_id_foreign');
		});
		Schema::table('post_tags', function(Blueprint $table) {
			$table->dropForeign('post_tags_post_id_foreign');
		});
		Schema::table('lives', function(Blueprint $table) {
			$table->dropForeign('lives_user_id_foreign');
		});
		Schema::table('live_tags', function(Blueprint $table) {
			$table->dropForeign('live_tags_locale_id_foreign');
		});
		Schema::table('live_tags', function(Blueprint $table) {
			$table->dropForeign('live_tags_live_id_foreign');
		});
		Schema::table('call_auction_participants', function(Blueprint $table) {
			$table->dropForeign('call_auction_participants_call_id_foreign');
		});
		Schema::table('call_auction_participants', function(Blueprint $table) {
			$table->dropForeign('call_auction_participants_user_id_foreign');
		});
		Schema::table('live_co_hosts', function(Blueprint $table) {
			$table->dropForeign('live_co_hosts_user_id_foreign');
		});
		Schema::table('live_co_hosts', function(Blueprint $table) {
			$table->dropForeign('live_co_hosts_live_id_foreign');
		});
		Schema::table('live_participants', function(Blueprint $table) {
			$table->dropForeign('live_participants_user_id_foreign');
		});
		Schema::table('live_participants', function(Blueprint $table) {
			$table->dropForeign('live_participants_live_id_foreign');
		});
		Schema::table('live_participants', function(Blueprint $table) {
			$table->dropForeign('live_participants_live_invitation_id_foreign');
		});
		Schema::table('live_invitations', function(Blueprint $table) {
			$table->dropForeign('live_invitations_user_id_foreign');
		});
		Schema::table('live_invitations', function(Blueprint $table) {
			$table->dropForeign('live_invitations_live_id_foreign');
		});
		Schema::table('live_tickets', function(Blueprint $table) {
			$table->dropForeign('live_tickets_user_id_foreign');
		});
		Schema::table('live_tickets', function(Blueprint $table) {
			$table->dropForeign('live_tickets_live_id_foreign');
		});
		Schema::table('live_tickets', function(Blueprint $table) {
			$table->dropForeign('live_tickets_live_invitation_id_foreign');
		});
		Schema::table('live_tickets', function(Blueprint $table) {
			$table->dropForeign('live_tickets_live_ticket_transaction_id_foreign');
		});
		Schema::table('user_calendars', function(Blueprint $table) {
			$table->dropForeign('user_calendars_live_id_foreign');
		});
		Schema::table('user_calendars', function(Blueprint $table) {
			$table->dropForeign('user_calendars_call_id_foreign');
		});
		Schema::table('user_calendars', function(Blueprint $table) {
			$table->dropForeign('user_calendars_user_id_foreign');
		});
		Schema::table('live_ticket_transactions', function(Blueprint $table) {
			$table->dropForeign('live_ticket_transactions_user_id_foreign');
		});
		Schema::table('live_ticket_transactions', function(Blueprint $table) {
			$table->dropForeign('live_ticket_transactions_live_id_foreign');
		});
		Schema::table('live_interactions', function(Blueprint $table) {
			$table->dropForeign('live_interactions_user_id_foreign');
		});
		Schema::table('live_interactions', function(Blueprint $table) {
			$table->dropForeign('live_interactions_live_id_foreign');
		});
		Schema::table('live_gifts', function(Blueprint $table) {
			$table->dropForeign('live_gifts_user_id_foreign');
		});
		Schema::table('live_gifts', function(Blueprint $table) {
			$table->dropForeign('live_gifts_live_id_foreign');
		});
		Schema::table('calls', function(Blueprint $table) {
			$table->dropForeign('calls_auction_last_bidder_id_foreign');
		});
		Schema::table('calls', function(Blueprint $table) {
			$table->dropForeign('calls_user_id_foreign');
		});
		Schema::table('call_auction_registers', function(Blueprint $table) {
			$table->dropForeign('call_auction_registers_call_id_foreign');
		});
		Schema::table('call_auction_registers', function(Blueprint $table) {
			$table->dropForeign('call_auction_registers_user_id_foreign');
		});
		Schema::table('call_invitations', function(Blueprint $table) {
			$table->dropForeign('call_invitations_call_id_foreign');
		});
		Schema::table('call_invitations', function(Blueprint $table) {
			$table->dropForeign('call_invitations_user_id_foreign');
		});
		Schema::table('call_ticket_transaction', function(Blueprint $table) {
			$table->dropForeign('call_ticket_transaction_call_id_foreign');
		});
		Schema::table('call_ticket_transaction', function(Blueprint $table) {
			$table->dropForeign('call_ticket_transaction_user_id_foreign');
		});
		Schema::table('call_tickets', function(Blueprint $table) {
			$table->dropForeign('call_tickets_call_id_foreign');
		});
		Schema::table('call_tickets', function(Blueprint $table) {
			$table->dropForeign('call_tickets_call_invitation_id_foreign');
		});
		Schema::table('call_tickets', function(Blueprint $table) {
			$table->dropForeign('call_tickets_call_ticket_transaction_id_foreign');
		});
		Schema::table('call_tickets', function(Blueprint $table) {
			$table->dropForeign('call_tickets_user_id_foreign');
		});
		Schema::table('call_participants', function(Blueprint $table) {
			$table->dropForeign('call_participants_call_id_foreign');
		});
		Schema::table('call_participants', function(Blueprint $table) {
			$table->dropForeign('call_participants_user_id_foreign');
		});
		Schema::table('call_tags', function(Blueprint $table) {
			$table->dropForeign('call_tags_locale_id_foreign');
		});
		Schema::table('call_tags', function(Blueprint $table) {
			$table->dropForeign('call_tags_call_id_foreign');
		});
		Schema::table('user_certified_user_calendars', function(Blueprint $table) {
			$table->dropForeign('user_certified_user_calendars_live_id_foreign');
		});
		Schema::table('user_certified_user_calendars', function(Blueprint $table) {
			$table->dropForeign('user_certified_user_calendars_call_id_foreign');
		});
		Schema::table('user_certified_user_calendars', function(Blueprint $table) {
			$table->dropForeign('user_certified_user_calendars_user_id_foreign');
		});
		Schema::table('user_center_of_interests', function(Blueprint $table) {
			$table->dropForeign('user_center_of_interests_center_of_interest_id_foreign');
		});
		Schema::table('user_center_of_interests', function(Blueprint $table) {
			$table->dropForeign('user_center_of_interests_user_id_foreign');
		});
		Schema::table('post_center_of_interests', function(Blueprint $table) {
			$table->dropForeign('post_center_of_interests_center_of_interest_id_foreign');
		});
		Schema::table('post_center_of_interests', function(Blueprint $table) {
			$table->dropForeign('post_center_of_interests_post_id_foreign');
		});
		Schema::table('live_center_of_interests', function(Blueprint $table) {
			$table->dropForeign('live_center_of_interests_center_of_interest_id_foreign');
		});
		Schema::table('live_center_of_interests', function(Blueprint $table) {
			$table->dropForeign('live_center_of_interests_live_id_foreign');
		});
		Schema::table('call_center_of_interests', function(Blueprint $table) {
			$table->dropForeign('call_center_of_interests_center_of_interest_id_foreign');
		});
		Schema::table('call_center_of_interests', function(Blueprint $table) {
			$table->dropForeign('call_center_of_interests_call_id_foreign');
		});
	}
}