<?php

class Call extends Eloquent {

	protected $table = 'calls';
	public $timestamps = true;

	public function calls()
	{
		return $this->hasMany('Call', 'Call');
	}

	public function user()
	{
		return $this->belongsTo('User', 'User');
	}

	public function registers()
	{
		return $this->hasMany('CallAuctionRegister', 'CallAuctionRegister');
	}

	public function invitation()
	{
		return $this->hasOne('CallInvitation', 'CallInvitation');
	}

	public function transaction()
	{
		return $this->hasMany('CallTicketTransaction', 'CallTicketTransaction');
	}

	public function ticket()
	{
		return $this->hasOne('CallTicket', 'CallTicket');
	}

	public function tags()
	{
		return $this->hasMany('CallTag', 'CallTag');
	}

	public function last_bidder()
	{
		return $this->belongsTo('User', 'User');
	}

	public function center_of_interests()
	{
		return $this->hasMany('CallCenterOfInterest', 'CallCenterOfInterest');
	}

}