<?php

class Live extends Eloquent {

	protected $table = 'lives';
	public $timestamps = true;

	public function tags()
	{
		return $this->hasMany('LiveTag', 'EventTag');
	}

	public function user()
	{
		return $this->hasOne('User', 'User');
	}

	public function invitations()
	{
		return $this->hasMany('LiveInvitation', 'LiveInvitation');
	}

	public function participants()
	{
		return $this->hasMany('LIveParticipants', 'LiveParticipant');
	}

	public function co_host()
	{
		return $this->hasMany('LiveCoHost', 'LiveCoHost');
	}

	public function tickets()
	{
		return $this->hasMany('LiveTicket', 'LiveTicket');
	}

	public function transactions()
	{
		return $this->hasMany('LiveTicketTransaction', 'LiveTransaction');
	}

	public function interactions()
	{
		return $this->hasMany('LiveInteractions', 'LiveInteraction');
	}

	public function gifts()
	{
		return $this->hasMany('LiveGift', 'LivetGift');
	}

	public function center_of_interests()
	{
		return $this->hasMany('LiveCenterOfInterest', 'LiveCenterOfInterest');
	}

}