<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LegalCase extends Model 
{

    protected $table = 'legal_cases';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function legalCaseServiceRequests()
    {
        return $this->hasMany('LegalCaseServiceRequests', 'legal_case_id');
    }

    public function afterSettlement()
    {
        return $this->hasOne('LegalCaseAfterSettlement', 'legal_case_id');
    }

}