<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LegalCaseServiceRequests extends Model 
{

    protected $table = 'legal_case_service_requests';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('ref_number', 'assigned_at');
    protected $visible = array('ref_number', 'assigned_at');

    public function servicePlans()
    {
        return $this->hasMany('LegalCaseServicePlans', 'legal_case_service_request_id');
    }

    public function legalCase()
    {
        return $this->belongsTo('LegalCase', 'legal_case_id');
    }

}