<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('car_models', function(Blueprint $table) {
			$table->foreign('car_brand_id')->references('id')->on('car_brands')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('car_model_types', function(Blueprint $table) {
			$table->foreign('car_model_id')->references('id')->on('car_models')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('inner_cars', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('inner_cars', function(Blueprint $table) {
			$table->foreign('inner_color_id')->references('id')->on('car_colors')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('inner_cars', function(Blueprint $table) {
			$table->foreign('outer_color_id')->references('id')->on('car_colors')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('inner_car_id')->references('id')->on('inner_cars')
						->onDelete('set null')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('car_models', function(Blueprint $table) {
			$table->dropForeign('car_models_car_brand_id_foreign');
		});
		Schema::table('car_model_types', function(Blueprint $table) {
			$table->dropForeign('car_model_types_car_model_id_foreign');
		});
		Schema::table('inner_cars', function(Blueprint $table) {
			$table->dropForeign('inner_cars_product_id_foreign');
		});
		Schema::table('inner_cars', function(Blueprint $table) {
			$table->dropForeign('inner_cars_inner_color_id_foreign');
		});
		Schema::table('inner_cars', function(Blueprint $table) {
			$table->dropForeign('inner_cars_outer_color_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_inner_car_id_foreign');
		});
	}
}