<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInnerCarsTable extends Migration {

	public function up()
	{
		Schema::create('inner_cars', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id')->unsigned();
			$table->string('engine_capacity');
			$table->integer('inner_color_id')->unsigned()->nullable();
			$table->integer('outer_color_id')->unsigned()->nullable();
			$table->enum('gear_type', array('manual', 'automatic', 'elctromatic'));
			$table->enum('supplier', array('gulf', 'saudi'));
			$table->string('main_image');
			$table->integer('car_status');
			$table->integer('price');
			$table->integer('have_discount');
			$table->integer('price_after');
			$table->integer('engine_size');
			$table->string('car_operation');
			$table->integer('ex_bluetooth');
			$table->integer('ex_aux');
			$table->integer('ex_cd');
			$table->integer('ex_navigator');
			$table->integer('ex_back_cam');
			$table->integer('ex_sensor_front');
			$table->integer('ex_sensor_back');
			$table->integer('ex_intellegance_entry');
			$table->integer('ex_sun_roof');
			$table->integer('ex_seat_type');
			$table->text('notes');
			$table->enum('new_or_used', array('new', 'used'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('inner_cars');
	}
}