<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tercero extends Model 
{

    protected $table = 'terceros';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function tipo_identificaion()
    {
        return $this->belongsToMany('TipoIdentificacion', 'id');
    }

    public function genero()
    {
        return $this->belongsToMany('Genero', 'id');
    }

    public function paciente()
    {
        return $this->hasOne('Paciente', 'id');
    }

    public function usuario()
    {
        return $this->hasOne('User', 'id');
    }

}