<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Comprobante extends Eloquent {

	protected $table = 'comprobantes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function documento()
	{
		return $this->belongsToMany('Documento', 'id');
	}

	public function sede()
	{
		return $this->belongsToMany('Sede', 'id');
	}

	public function tercero()
	{
		return $this->belongsToMany('Tercero', 'id');
	}

}