<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Liquidacion extends Eloquent {

	protected $table = 'liquidaciones';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function sede()
	{
		return $this->belongsTo('Sede', 'id');
	}

	public function documento()
	{
		return $this->belongsTo('Documento', 'id');
	}

	public function productos()
	{
		return $this->hasMany('LiquidacionProducto', 'liquidacion_id');
	}

	public function servicios()
	{
		return $this->hasMany('LiquidacionServicio', 'liquidacion_id');
	}

	public function paciente()
	{
		return $this->belongsTo('Paciente', 'id');
	}

}