<?php

namespace paciente;

class Paciente extends Eloquent {

	protected $table = 'pacientes';
	public $timestamps = true;

	public function ocupaciones()
	{
		return $this->belongsToMany('Ocupacion', 'id');
	}

	public function pertenencia_etnica()
	{
		return $this->belongsToMany('Pertenencia_etnica', 'id');
	}

	public function tipos_rh()
	{
		return $this->belongsToMany('Tipo_rh', 'id');
	}

	public function tercero()
	{
		return $this->belongsTo('Tercero', 'id');
	}

	public function escolaridad()
	{
		return $this->belongsToMany('Escolaridad', 'id');
	}

	public function tipoRegimen()
	{
		return $this->belongsToMany('TipoRegimen');
	}

}