<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCourseTable extends Migration {

	public function up()
	{
		Schema::create('Course', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 40);
			$table->float('price');
			$table->smallInteger('duration');
			$table->text('description');
			$table->string('summery', 140);
			$table->boolean('is_promoted');
			$table->integer('category_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('Course');
	}
}