<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Attribute extends Model 
{

    protected $table = 'attributable_attributes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('attribute_type', 'attribute_id', 'attribute_key', 'attribute_value');

    public function attributable()
    {
        return $this->morphTo();
    }

}