<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRuleMainsTable extends Migration {

	public function up()
	{
		Schema::create('rule_mains', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('beacon_campaign_id')->nullable();
			$table->string('name')->nullable();
			$table->string('type')->nullable();
			$table->string('status')->nullable();
			$table->integer('delay')->unsigned()->nullable()->default('0');
			$table->string('device_target_type')->nullable();
			$table->string('status_upload')->nullable();
			$table->integer('redirect_message_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('rule_mains');
	}
}