<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSmellsTable extends Migration {

	public function up()
	{
		Schema::create('smells', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 50)->unique();
			$table->longText('description')->default('null');
			$table->decimal('price');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('smells');
	}
}