<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReturnsTable extends Migration {

	public function up()
	{
		Schema::create('returns', function(Blueprint $table) {
			$table->increments('id');
			$table->string('order_number', 10);
			$table->string('customer_name', 50);
			$table->string('customer_phone', 50);
			$table->string('customer_email', 50);
			$table->uuid('area_id');
			$table->uuid('city_id');
			$table->string('address', 150);
			$table->date('expected_delivery_date');
			$table->integer('status')->default('0');
			$table->uuid('merchant_id');
			$table->uuid('user_id');
			$table->uuid('order_id');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('returns');
	}
}