<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuoteRequestsTable extends Migration {

	public function up()
	{
		Schema::create('quote_requests', function(Blueprint $table) {
			$table->uuid('id')->primary();
			$table->string('request_needed', 250);
			$table->string('product_type', 100);
			$table->string('shipment_type', 100);
			$table->char('item_insured', 10);
			$table->uuid('warehouse_city_id');
			$table->string('products_temperature_needed', 200);
			$table->string('packed_type', 100);
			$table->string('inbound_shipments', 250);
			$table->uuid('user_id');
			$table->integer('status');
			$table->uuid('merchant_id');
			$table->string('request_number')->unique();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('quote_requests');
	}
}