<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('security_question_id')->references('id')->on('seurity_questions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('password_resets', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->foreign('module_id')->references('id')->on('permission_modules')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permission_used', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permission_used', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('invoice_generation_date_id')->references('id')->on('invoice_generation_dates')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('client_category_id')->references('id')->on('client_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('IP_white_lists', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contact_persons', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contact_persons', function(Blueprint $table) {
			$table->foreign('position_id')->references('id')->on('company_positions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('game_masters', function(Blueprint $table) {
			$table->foreign('game_category_id')->references('id')->on('game_category')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('game_masters', function(Blueprint $table) {
			$table->foreign('game_provider_id')->references('id')->on('game_providers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('game_masters', function(Blueprint $table) {
			$table->foreign('game_type_id')->references('id')->on('game_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('password_change_history', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('oauth_secret_token', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('operators', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('operators', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('players', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('client_bank_account', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('client_bank_account', function(Blueprint $table) {
			$table->foreign('master_bank_id')->references('id')->on('master_banks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('client_bank_account', function(Blueprint $table) {
			$table->foreign('available_bank_group_id')->references('id')->on('available_bank_groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bank_group_config', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bank_group_config', function(Blueprint $table) {
			$table->foreign('available_bank_group_id')->references('id')->on('available_bank_groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bank_group_config', function(Blueprint $table) {
			$table->foreign('master_bank_id')->references('id')->on('master_banks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('master_bank_visibilities', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('master_bank_visibilities', function(Blueprint $table) {
			$table->foreign('master_bank_id')->references('id')->on('master_banks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('master_bank_visibilities', function(Blueprint $table) {
			$table->foreign('alternative_bank')->references('id')->on('client_bank_account')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('transaction_type_id')->references('id')->on('transaction_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('verified_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('client_bank_account_id')->references('id')->on('client_bank_account')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('player_bank_accounts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('player_bank_accounts', function(Blueprint $table) {
			$table->foreign('master_bank_id')->references('id')->on('master_banks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('player_bank_accounts', function(Blueprint $table) {
			$table->foreign('current_bank_group_id')->references('id')->on('available_bank_groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('blogs', function(Blueprint $table) {
			$table->foreign('added_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('blogs', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_client_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_security_question_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->dropForeign('roles_client_id_foreign');
		});
		Schema::table('password_resets', function(Blueprint $table) {
			$table->dropForeign('password_resets_user_id_foreign');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->dropForeign('permissions_module_id_foreign');
		});
		Schema::table('permission_used', function(Blueprint $table) {
			$table->dropForeign('permission_used_permission_id_foreign');
		});
		Schema::table('permission_used', function(Blueprint $table) {
			$table->dropForeign('permission_used_role_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_currency_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_invoice_generation_date_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_client_category_id_foreign');
		});
		Schema::table('IP_white_lists', function(Blueprint $table) {
			$table->dropForeign('IP_white_lists_user_id_foreign');
		});
		Schema::table('contact_persons', function(Blueprint $table) {
			$table->dropForeign('contact_persons_client_id_foreign');
		});
		Schema::table('contact_persons', function(Blueprint $table) {
			$table->dropForeign('contact_persons_position_id_foreign');
		});
		Schema::table('game_masters', function(Blueprint $table) {
			$table->dropForeign('game_masters_game_category_id_foreign');
		});
		Schema::table('game_masters', function(Blueprint $table) {
			$table->dropForeign('game_masters_game_provider_id_foreign');
		});
		Schema::table('game_masters', function(Blueprint $table) {
			$table->dropForeign('game_masters_game_type_id_foreign');
		});
		Schema::table('password_change_history', function(Blueprint $table) {
			$table->dropForeign('password_change_history_user_id_foreign');
		});
		Schema::table('oauth_secret_token', function(Blueprint $table) {
			$table->dropForeign('oauth_secret_token_user_id_foreign');
		});
		Schema::table('operators', function(Blueprint $table) {
			$table->dropForeign('operators_user_id_foreign');
		});
		Schema::table('operators', function(Blueprint $table) {
			$table->dropForeign('operators_client_id_foreign');
		});
		Schema::table('players', function(Blueprint $table) {
			$table->dropForeign('players_user_id_foreign');
		});
		Schema::table('client_bank_account', function(Blueprint $table) {
			$table->dropForeign('client_bank_account_client_id_foreign');
		});
		Schema::table('client_bank_account', function(Blueprint $table) {
			$table->dropForeign('client_bank_account_master_bank_id_foreign');
		});
		Schema::table('client_bank_account', function(Blueprint $table) {
			$table->dropForeign('client_bank_account_available_bank_group_id_foreign');
		});
		Schema::table('bank_group_config', function(Blueprint $table) {
			$table->dropForeign('bank_group_config_client_id_foreign');
		});
		Schema::table('bank_group_config', function(Blueprint $table) {
			$table->dropForeign('bank_group_config_available_bank_group_id_foreign');
		});
		Schema::table('bank_group_config', function(Blueprint $table) {
			$table->dropForeign('bank_group_config_master_bank_id_foreign');
		});
		Schema::table('master_bank_visibilities', function(Blueprint $table) {
			$table->dropForeign('master_bank_visibilities_client_id_foreign');
		});
		Schema::table('master_bank_visibilities', function(Blueprint $table) {
			$table->dropForeign('master_bank_visibilities_master_bank_id_foreign');
		});
		Schema::table('master_bank_visibilities', function(Blueprint $table) {
			$table->dropForeign('master_bank_visibilities_alternative_bank_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_user_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_client_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_transaction_type_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_verified_by_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_client_bank_account_id_foreign');
		});
		Schema::table('player_bank_accounts', function(Blueprint $table) {
			$table->dropForeign('player_bank_accounts_user_id_foreign');
		});
		Schema::table('player_bank_accounts', function(Blueprint $table) {
			$table->dropForeign('player_bank_accounts_master_bank_id_foreign');
		});
		Schema::table('player_bank_accounts', function(Blueprint $table) {
			$table->dropForeign('player_bank_accounts_current_bank_group_id_foreign');
		});
		Schema::table('blogs', function(Blueprint $table) {
			$table->dropForeign('blogs_added_by_foreign');
		});
		Schema::table('blogs', function(Blueprint $table) {
			$table->dropForeign('blogs_client_id_foreign');
		});
	}
}