<?php

namespace App\Models;

class AvailableBankGroup extends Eloquent {

	protected $table = 'available_bank_groups';
	public $timestamps = true;
	protected $fillable = array('group_name', 'description', 'status');

	public function client_bank_accounts()
	{
		return $this->hasMany('App\Models\ClientBankAccount', 'available_bank_group_id');
	}

	public function bank_group_config()
	{
		return $this->hasMany('App\Models\BankGroupConfig', 'available_bank_group_id');
	}

}