<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('client_name', 'key_hash', 'domain_name', 'url_authenticate', 'prefix', 'currency_id', 'deposit_limit', 'client_category_id', 'allow_print', 'maximum_downline');
	protected $visible = array('status');

	public function users()
	{
		return $this->hasMany('App\Models\User', 'client_id');
	}

	public function invoice_generation_dates()
	{
		return $this->hasOne('App\Models\InvoiceGenerationDate', 'invoice_generation_date_id');
	}

	public function client_categories()
	{
		return $this->hasOne('App\Models\ClientCategory', 'client_category_id');
	}

	public function currencies()
	{
		return $this->hasOne('App\Models\Currency', 'currency_id');
	}

	public function contact_persons()
	{
		return $this->hasMany('App\Models\ContactPerson', 'client_id');
	}

	public function operators()
	{
		return $this->hasMany('App\Models\Operator', 'client_id');
	}

	public function client_bank_accounts()
	{
		return $this->hasMany('App\Models\ClientBankAccount', 'client_id');
	}

	public function bank_group_config()
	{
		return $this->hasMany('App\Models\BankGroupConfig', 'client_id');
	}

	public function master_bank_visibility()
	{
		return $this->hasMany('App\Models\MasterBankVisibility', 'client_id');
	}

	public function blogs()
	{
		return $this->hasMany('App\Models\Blog', 'client_id');
	}

}